/*
 * Decompiled with CFR 0.152.
 */
package org.bretts.scala.generics;

public class JavaVariance {
    public static <T> String rigidStringify(Container<T> container, Formatter<T> formatter) {
        return formatter.format(container.contained);
    }

    public static <T> String contravariantStringify(Container<? extends T> container, Formatter<T> formatter) {
        return formatter.format(container.contained);
    }

    public static <T> String covariantStringify(Container<T> container, Formatter<? super T> formatter) {
        return formatter.format(container.contained);
    }

    public static <T> String flexibleStringify(Container<? extends T> container, Formatter<? super T> formatter) {
        return formatter.format(container.contained);
    }

    public static void main(String[] args) {
        Container<Child> container = new Container<Child>(new Child(1, "foo"));
        Formatter formatter = new Formatter();
        JavaVariance.contravariantStringify(container, formatter);
        JavaVariance.covariantStringify(container, formatter);
        JavaVariance.flexibleStringify(container, formatter);
        JavaVariance.flexibleStringify(container, formatter);
    }

    public static class Formatter<T> {
        public String format(T obj) {
            return "Value: " + obj;
        }
    }

    public static class Container<T> {
        public final T contained;

        public Container(T contained) {
            this.contained = contained;
        }
    }

    public static class Child
    extends Parent {
        public final String str;

        public Child(int i, String str) {
            super(i);
            this.str = str;
        }
    }

    public static class Parent {
        public final int i;

        public Parent(int i) {
            this.i = i;
        }
    }
}

