/*
 * Decompiled with CFR 0.152.
 */
package org.bretts.scala.lib.jmh;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import org.bretts.scala.lib.jmh.SegmentizeTest;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=1)
@Warmup(iterations=3)
@Measurement(iterations=3)
public class SegmentizeJava {
    public static final int total = 100000;
    public static final int step = 10;
    List<Integer> as = new ArrayList<Integer>();
    List<Integer> bs = new ArrayList<Integer>();
    BiPredicate<Integer, Integer> f;
    BiPredicate<Integer, Integer> f1;
    public final SegmentizeTest scala;

    public SegmentizeJava() {
        for (int i = 1; i < 100000; ++i) {
            this.as.add(i);
            if (i % 10 != 0) continue;
            this.bs.add(i);
        }
        this.f = new BiPredicate<Integer, Integer>(){

            @Override
            public boolean test(Integer t, Integer u) {
                return t >= u;
            }
        };
        this.f1 = (t, u) -> t >= u;
        this.scala = new SegmentizeTest();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*\\." + SegmentizeJava.class.getSimpleName() + "\\.segScala.*").build();
        new Runner(opt).run();
    }

    @Benchmark
    public List<List<Integer>> segJava() {
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>();
        int ia = 0;
        for (Integer b : this.bs) {
            ArrayList<Integer> segment = new ArrayList<Integer>();
            res.add(segment);
            while (ia < this.as.size() && !this.f.test(this.as.get(ia), b)) {
                segment.add(this.as.get(ia));
                ++ia;
            }
        }
        if (ia < this.as.size()) {
            ArrayList<Integer> segment = new ArrayList<Integer>();
            res.add(segment);
            for (int i = ia; i < this.as.size(); ++i) {
                segment.add(this.as.get(i));
            }
        }
        return res;
    }

    @Benchmark
    public List<List<Integer>> segJava8() {
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>();
        int ia = 0;
        for (Integer b : this.bs) {
            ArrayList<Integer> segment = new ArrayList<Integer>();
            res.add(segment);
            while (ia < this.as.size() && !this.f1.test(this.as.get(ia), b)) {
                segment.add(this.as.get(ia));
                ++ia;
            }
        }
        if (ia < this.as.size()) {
            ArrayList<Integer> segment = new ArrayList<Integer>();
            res.add(segment);
            for (int i = ia; i < this.as.size(); ++i) {
                segment.add(this.as.get(i));
            }
        }
        return res;
    }

    @Benchmark
    public List<List<Integer>> segJavaOpt() {
        int asize = this.as.size();
        int bsize = this.bs.size();
        int twiceAvgSegmentSize = 2 * asize / bsize;
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>(bsize + 1);
        int ia = 0;
        for (Integer b : this.bs) {
            ArrayList<Integer> segment = new ArrayList<Integer>(twiceAvgSegmentSize);
            res.add(segment);
            while (ia < asize && this.as.get(ia) < b) {
                segment.add(this.as.get(ia));
                ++ia;
            }
        }
        if (ia < asize) {
            ArrayList<Integer> segment = new ArrayList<Integer>(twiceAvgSegmentSize);
            res.add(segment);
            for (int i = ia; i < asize; ++i) {
                segment.add(this.as.get(i));
            }
        }
        return res;
    }

    @Benchmark
    public List<List<Integer>> segJavaOpt2() {
        int asize = this.as.size();
        int bsize = this.bs.size();
        int twiceAvgSegmentSize = 2 * asize / bsize;
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>(bsize + 1);
        int ia = 0;
        for (Integer b : this.bs) {
            Integer a;
            ArrayList<Integer> segment = new ArrayList<Integer>(twiceAvgSegmentSize);
            res.add(segment);
            while (ia < asize && (a = this.as.get(ia)) < b) {
                segment.add(a);
                ++ia;
            }
        }
        if (ia < asize) {
            ArrayList<Integer> segment = new ArrayList<Integer>(twiceAvgSegmentSize);
            res.add(segment);
            for (int i = ia; i < asize; ++i) {
                segment.add(this.as.get(i));
            }
        }
        return res;
    }

    @Benchmark
    public List<List<Integer>> segJavaOpt3() {
        int asize = this.as.size();
        int bsize = this.bs.size();
        int twiceAvgSegmentSize = 2 * asize / bsize;
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>(bsize + 1);
        int ia = 0;
        for (Integer b : this.bs) {
            Integer a;
            int bInt = b;
            ArrayList<Integer> segment = new ArrayList<Integer>(twiceAvgSegmentSize);
            res.add(segment);
            while (ia < asize && (a = this.as.get(ia)) < bInt) {
                segment.add(a);
                ++ia;
            }
        }
        if (ia < asize) {
            ArrayList<Integer> segment = new ArrayList<Integer>(twiceAvgSegmentSize);
            res.add(segment);
            for (int i = ia; i < asize; ++i) {
                segment.add(this.as.get(i));
            }
        }
        return res;
    }

    @Benchmark
    public List<List<Integer>> segJavaOpt4() {
        int asize = this.as.size();
        int bsize = this.bs.size();
        int twiceAvgSegmentSize = 2 * asize / bsize;
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>(bsize + 1);
        int ia = 0;
        for (Integer b : this.bs) {
            Integer a;
            int bInt = b;
            ArrayList<Integer> segment = new ArrayList<Integer>(twiceAvgSegmentSize);
            res.add(segment);
            while (ia < asize && (a = this.as.get(ia)) < bInt) {
                segment.add(a);
                ++ia;
            }
        }
        if (ia < asize) {
            ArrayList<Integer> segment = new ArrayList<Integer>(twiceAvgSegmentSize);
            res.add(segment);
            for (int i = ia; i < asize; ++i) {
                segment.add(this.as.get(i));
            }
        }
        return res;
    }

    @Benchmark
    public Object segScala() {
        return this.scala.seg();
    }

    @Benchmark
    public Object segScalaMut() {
        return this.scala.segMut();
    }

    public Object segScala2() {
        return this.scala.seg2();
    }

    public Object segScalaOpt() {
        return this.scala.segOpt();
    }

    @Benchmark
    public Object segScalaVec() {
        return this.scala.segVec();
    }

    @Benchmark
    public Object segScalaQueue() {
        return this.scala.segQueue();
    }
}

